% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_methods_reservoir_predict_seq.R
\name{plot.reservoir_predict_seq}
\alias{plot.reservoir_predict_seq}
\title{plot.reservoir_predict_seq}
\usage{
\method{plot}{reservoir_predict_seq}(x, ..., vec_nodes = c(1:20), vec_time = NULL)
}
\arguments{
\item{x}{A reservoir_predict_seq object}

\item{...}{deprecated}

\item{vec_nodes}{Number of nodes to plot}

\item{vec_time}{Time to plot}
}
\value{
A ggplot
}
\description{
plot.reservoir_predict_seq
}
\examples{
\dontrun{
if(reticulate::py_module_available("reservoirpy")){
reservoir <- reservoirnet::createNode(nodeType = "Reservoir",
                                      seed = 1,
                                      units = 100,
                                      lr = 0.7,
                                      sr = 1,
                                      input_scaling = 1)
X <- matrix(data = rnorm(100), ncol = 4)
reservoir_state_stand <- reservoirnet::predict_seq(node = reservoir, X = X)
plot(reservoir_state_stand)
summary(reservoir_state_stand)
}
}

}
