% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_search_hyperparam.R
\name{random_search_hyperparam}
\alias{random_search_hyperparam}
\title{random_search_hyperparam}
\usage{
random_search_hyperparam(
  n = 100,
  ls_fct = list(ridge = function(n) 1e-05, input_scaling = function(n) 1, spectral_radius
    = function(n) rloguniform(n = n, min = 0.01, max = 10), leaking_rate = function(n)
    rloguniform(n = n, min = 0.001, max = 1))
)
}
\arguments{
\item{n}{Number of search}

\item{ls_fct}{A list of functions}
}
\value{
A dataframe of size n x 4. Each row is a different set of hyperparameters.
}
\description{
Generate a hyperparameter simulation table using functions as input.
}
\examples{
random_search_hyperparam(
  n = 100,
  ls_fct = list(
    ridge = function(n)
      1e-5,
    input_scaling = function(n)
      1,
    spectral_radius = function(n)
      rloguniform(n = n, min = 1e-2, max = 10),
    leaking_rate = function(n)
      rloguniform(n = n, min = 1e-3, max = 1)
  )
)

}
