% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_weibull.R
\name{dist_weibull}
\alias{dist_weibull}
\title{Weibull Distribution}
\usage{
dist_weibull(shape = NULL, scale = NULL)
}
\arguments{
\item{shape}{Scalar shape parameter, or \code{NULL} as a placeholder.}

\item{scale}{Scalar scale parameter, or \code{NULL} as a placeholder.}
}
\value{
A \code{WeibullDistribution} object.
}
\description{
See \link[stats:Weibull]{stats::Weibull}
}
\details{
Both parameters can be overridden with
\code{with_params = list(shape = ..., scale = ...)}.
}
\examples{
d_weibull <- dist_weibull(shape = 3, scale = 1)
x <- d_weibull$sample(100)
d_emp <- dist_empirical(x)

plot_distributions(
  empirical = d_emp,
  theoretical = d_weibull,
  estimated = d_weibull,
  with_params = list(
    estimated = inflate_params(
      fitdistrplus::fitdist(x, distr = "weibull")$estimate
    )
  ),
  .x = seq(0, 2, length.out = 100)
)

}
\seealso{
Other Distributions: 
\code{\link{Distribution}},
\code{\link{dist_bdegp}()},
\code{\link{dist_beta}()},
\code{\link{dist_binomial}()},
\code{\link{dist_blended}()},
\code{\link{dist_dirac}()},
\code{\link{dist_discrete}()},
\code{\link{dist_empirical}()},
\code{\link{dist_erlangmix}()},
\code{\link{dist_exponential}()},
\code{\link{dist_gamma}()},
\code{\link{dist_genpareto}()},
\code{\link{dist_lognormal}()},
\code{\link{dist_mixture}()},
\code{\link{dist_negbinomial}()},
\code{\link{dist_normal}()},
\code{\link{dist_pareto}()},
\code{\link{dist_poisson}()},
\code{\link{dist_translate}()},
\code{\link{dist_trunc}()},
\code{\link{dist_uniform}()}
}
\concept{Distributions}
