% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restopt_problem.R
\name{print.RestoptProblem}
\alias{print.RestoptProblem}
\title{Print a restoration optimization problem}
\usage{
\method{print}{RestoptProblem}(x, ...)
}
\arguments{
\item{x}{\code{\link[=restopt_problem]{restopt_problem()}} Restoration problem object.}

\item{...}{Arguments not used.}
}
\description{
Display information about a restoration optimization problem.
}
\examples{
\dontrun{
#' # load data
habitat_data <- rast(
  system.file("extdata", "habitat_hi_res.tif", package = "restoptr")
)

# create problem
p <- restopt_problem(
       existing_habitat = habitat_data,
       aggregation_factor = 4,
       habitat_threshold = 0.7
)

# print problem
print(p)
}

}
