% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resumiR.R
\name{s_agrupada}
\alias{s_agrupada}
\title{Tablas de Frecuencias y Gráficos para Datos Numéricos}
\usage{
s_agrupada(
  x,
  decimales = 1,
  li = NULL,
  ls = NULL,
  a = NULL,
  derecha = TRUE,
  grafico = "ninguno",
  frec = "relativa",
  pf = FALSE,
  ...
)
}
\arguments{
\item{x}{vector numérico de tipo *integer* o *numeric*; en este último caso, el vector debe tener una longitud mayor a 1, y permitir el cálculo de medidas de variabilidad.}

\item{decimales}{el número de posiciones decimales de los resultados.}

\item{li}{límite inferior del primer intervalo de clase, para datos de tipo *numeric*.}

\item{ls}{límite superior del intervalo de clase superior, para datos de tipo *numeric*.}

\item{a}{amplitud del intervalo de clase, para datos de tipo *numeric*.}

\item{derecha}{si los intervalos de clase son cerrados por derecha, para datos de tipo *numeric*.}

\item{grafico}{texto indicando el tipo de gráfico a realizar: frecuencias simples, acumuladas o ambas; los valores posibles son "ninguno", "fs" y "fa"; por defecto es "ninguno"; hereda propiedades de ggplot()}

\item{frec}{texto indicando tipo de frecuencia a utilizar en caso de realizar un gráfico; los valores posibles son "absoluta" y "relativa"; por defecto es "absoluta".}

\item{pf}{lógico; si es verdadero (TRUE), devuelve el polígono de frecuencias en lugar del histograma de frecuencias, cuando x es continua; por defecto es FALSE.}

\item{...}{argumentos que heredan de la función ggplot()}
}
\value{
Devuelve una tabla de frecuencias para datos continuos o discretos; cuando el argumento gráfico es "fs" o "fa" devuelve el gráfico de frecuencias simples y acumulados respeectivamente, adecuados para cada tipo de variable
}
\description{
Devuelve la tabla de frecuencias de una serie univariada de datos numéricos enteros o continuos. En el caso de datos de tipo continuo, es posible especificar los límites y la amplitud de los intervalos de clase. Por defecto, construye los intervalos de clase cerrados por derecha, con la regla de Sturges.
}
\examples{
library(resumiR)
x = iris[[1]]
s_agrupada(x, li=4, ls=8, a=1, grafico="fs")
s_agrupada(x, grafico="fs", pf=TRUE)
s_agrupada(x, grafico="fa")
}
