% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfm-plots.R
\name{rfm_plot_heatmap}
\alias{rfm_plot_heatmap}
\alias{rfm_heatmap}
\title{RFM heatmap}
\usage{
rfm_plot_heatmap(
  data,
  brewer_n = 5,
  brewer_name = "PuBu",
  xaxis_label = NULL,
  yaxis_label = NULL,
  plot_title = NULL,
  legend_title = NULL,
  interactive = FALSE,
  print_plot = TRUE
)
}
\arguments{
\item{data}{An object of class \code{rfm_table}.}

\item{brewer_n}{Indicates the number of colors in the palette; RColorBrewer
is used for the color palette of the heatmap; check the documentation of
\code{brewer.pal}.}

\item{brewer_name}{Palette name; check the documentation of
\code{brewer.pal}.}

\item{xaxis_label}{X axis label.}

\item{yaxis_label}{Y axis label.}

\item{plot_title}{Title of the plot.}

\item{legend_title}{Legend title.}

\item{interactive}{If \code{TRUE}, uses \code{plotly} as the visualization
engine. If \code{FALSE}, uses \code{ggplot2}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a
plot object.}
}
\description{
The heat map shows the average monetary value for different
  categories of recency and frequency scores. Higher scores of frequency and
  recency are characterized by higher average monetary value as indicated by
  the darker areas in the heatmap.
}
\section{Deprecated Functions}{

\code{rfm_heatmap()} has been deprecated and will be made defunct. It has
been provided for compatibility with older versions only, and will be made
defunct at the next release.

Instead use the replacement function \code{rfm_plot_heatmap()}.
}

\examples{
# using transaction data
analysis_date <- as.Date('2006-12-31')
rfm_order <- rfm_table_order(rfm_data_orders, customer_id, order_date,
revenue, analysis_date)

# heat map
# ggplot2
rfm_plot_heatmap(rfm_order)

# plotly
rfm_plot_heatmap(rfm_order, interactive = TRUE)

# using customer data
analysis_date <- as.Date('2007-01-01')
rfm_customer <- rfm_table_customer(rfm_data_customer, customer_id,
number_of_orders, recency_days, revenue, analysis_date)

# heat map
rfm_plot_heatmap(rfm_customer)

}
