% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regGE.R
\name{regGE}
\alias{regGE}
\alias{regGE.default}
\alias{regGE.formula}
\title{Generalized Edition for Regression}
\usage{
\method{regGE}{default}(x, y, t = 0.2, k = 5, ...)

\method{regGE}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a double vector with the output regressand of each sample.}

\item{t}{a double in [0,1] with the \emph{threshold} used by regression noise filter (default: 0.2).}

\item{k}{an integer with the number of nearest neighbors to be used (default: 5).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output regressand and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
The result of applying the regression filter is a reduced dataset containing the clean samples (without errors or noise), since it removes noisy samples (those with errors).
This function returns an object of class \code{rfdata}, which contains information related to the noise filtering process in the form of a list with the following elements:
\item{xclean}{a data frame with the input attributes of clean samples (without errors).}
\item{yclean}{a double vector with the output regressand of clean samples (without errors).}
\item{numclean}{an integer with the amount of clean samples.}
\item{idclean}{an integer vector with the indices of clean samples.}
\item{xnoise}{a data frame with the input attributes of noisy samples (with errors).}
\item{ynoise}{a double vector with the output regressand of noisy samples (with errors).}
\item{numnoise}{an integer with the amount of noisy samples.}
\item{idnoise}{an integer vector with the indices of noisy samples.}
\item{filter}{the full name of the noise filter used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}

Note that objects of the class \code{rfdata} support \link{print.rfdata}, \link{summary.rfdata} and \link{plot.rfdata} methods.
}
\description{
Application of the regGE noise filtering method in a regression dataset.
}
\details{
In classification, \emph{Generalized Edition} (GE) is a generalization of ENN, which can relabel a sample if at least half of its nearest neighbors (\code{k})
have the same class label; otherwise it is removed. The implementation of this noise filter to be used in regression problems follows the proposal of Martín \emph{et al.} (2021),
which is based on the use of a noise threshold (\code{t}) to determine the similarity between the output variable of the samples.
}
\examples{
# load the dataset
data(rock)

# usage of the default method
set.seed(9)
out.def <- regGE(x = rock[,-ncol(rock)], y = rock[,ncol(rock)])

# show results
summary(out.def, showid = TRUE)

# usage of the method for class formula
set.seed(9)
out.frm <- regGE(formula = perm ~ ., data = rock)

# check the match of noisy indices
all(out.def$idnoise == out.frm$idnoise)

}
\references{
J. Koplowitz and T. A. Brown,
\strong{On the relation of performance to editing in nearest neighbor rules},
\emph{Pattern Recognition}, 13:251-255, 1981.
\doi{https://doi.org/10.1016/0031-3203(81)90102-3}.

J. Martín, J. A. Sáez and E. Corchado,
\strong{On the regressand noise problem: Model robustness and synergy with regression-adapted noise filters.}
\emph{IEEE Access}, 9:145800-145816, 2021.
\doi{https://doi.org/10.1109/ACCESS.2021.3123151}.
}
\seealso{
\code{\link{regENN}}, \code{\link{regAENN}}, \code{\link{regRNN}}, \code{\link{print.rfdata}}, \code{\link{summary.rfdata}}
}
