% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geonames_download.R
\name{geonames_download}
\alias{geonames_download}
\title{Download State Register of Geographical Names}
\usage{
geonames_download(type, format = "SHP", outdir = ".", unzip = TRUE, ...)
}
\arguments{
\item{type}{names of places ("place") and/or physiographic objects ("object")}

\item{format}{data format ("GML", "SHP" (default) and/or "XLSX")}

\item{outdir}{(optional) name of the output directory;
by default, files are saved in the working directory}

\item{unzip}{TRUE (default) or FALSE, when TRUE the downloaded archive will
be extracted and removed}

\item{...}{additional argument for \code{\link[utils:download.file]{utils::download.file()}}}
}
\value{
a selected data type in the specified format
}
\description{
Download State Register of Geographical Names
}
\examples{
\dontrun{
geonames_download(type = "place", format = "SHP") # 18.2 MB
}
}
\references{
\url{https://isap.sejm.gov.pl/isap.nsf/download.xsp/WDU20150000219/O/D20150219.pdf}
}
