% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTestSet.R
\name{getTestSet}
\alias{getTestSet}
\title{Get Test Set}
\usage{
getTestSet(set, testSetLength, testSetBaserateInflation = 0)
}
\arguments{
\item{set}{The \code{\link{codeSet}} from which the \emph{testSet} is taken}

\item{testSetLength}{The length of the \emph{testSet} to be taken}

\item{testSetBaserateInflation}{The minimum guaranteed \code{\link{baserate}} of the \emph{testSet}. Default to 0}
}
\value{
A \code{\link{codeSet}} with the properties specified
}
\description{
This function gets a \emph{testSet} from a larger \code{\link{codeSet}} given certain sampling parameters.
}
\details{
A \emph{testSet} is a \code{\link{codeSet}} that is a subset of a larger \code{\link{codeSet}} with a given set of properties.  A \emph{testSet} is constructed by sampling (without replacement) P rows from rows in the larger \code{\link{codeSet}} where the first rater's code was 1, and then appending an additional sample (without replacement) of R rows taken at random from the larger \code{\link{codeSet}} excluding rows included in the first P rows sampled. P is computed as the minbaserate * length of the \emph{testset}. R is computed as testSetLength - P. The result of this sampling procedure is to create a sample with a minimum baserate regardless of the baserate of the larger \code{\link{codeSet}}.If \emph{testSetBaserateInflation} is set to zero, the function selects rows at random.
}
