% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_bispectra.R
\name{cross_bicoherence}
\alias{cross_bicoherence}
\title{Estimate cross-bicoherence from time series data.}
\usage{
cross_bicoherence(
  x,
  y,
  z = y,
  dft_given = FALSE,
  mc = FALSE,
  mc_cores = getOption("mc.cores", 2L)
)
}
\arguments{
\item{x}{Given 1st time series, as a data frame or matrix with which columns
correspond to sampled stretches.}

\item{y}{Given 2nd time series, with the same dimension as x.}

\item{z}{Optional 3rd time series, with the same dimension as x (and thus as y).
If omitted, \code{y} is used instead.}

\item{dft_given}{If TRUE, suppose that DFTs are given instead of time series
data and skip the fast fourier transform. Default: \code{FALSE}.}

\item{mc}{If \code{TRUE}, calculation is done in parallel computation.
Defaults to \code{FALSE}.}

\item{mc_cores}{The number of cores in use for parallel computation, passed
\code{\link[parallel:mclapply]{parallel::mclapply}()} etc. as \code{mc.cores}.}
}
\value{
A data frame including the following columns:
\describe{
\item{f1:}{
The first elements of frequency pairs.
}
\item{f2:}{
The second elements of frequency pairs.
}
\item{value:}{
The estimated value of magnitude-squared cross-bicoherence at the respective
frequency pair.
}
}
}
\description{
Estimate cross-bicoherence from three real-valued time series data.
}
\examples{
x <- seq_len(1280)
v1 <- sapply(x, function(x) {sin(2 * x)}) + rnorm(1280)
v2 <- sapply(x, function(x) {sin(3 * x + 1)}) + rnorm(1280)
v3 <- sapply(x, function(x) {cos(2 * x) * cos(3 * x + 1)}) + rnorm(1280)
m1 <- matrix(v1, nrow = 128)
m2 <- matrix(v2, nrow = 128)
m3 <- matrix(v3, nrow = 128)
xbc1 <- cross_bicoherence(m1, m2, m3)

d1 <- stats::mvfft(m1)
d2 <- stats::mvfft(m2)
d3 <- stats::mvfft(m3)
xbc2 <- cross_bicoherence(d1, d2, d3, dft_given = TRUE)

xbc3 <- cross_bicoherence(d1, d2, d3, dft_given = TRUE, mc = TRUE, mc_cores = 1L)

}
\references{
Kim, Y.C., Powers, E.J., 1979. Digital Bispectral Analysis and Its Applications to Nonlinear Wave Interactions. IEEE Trans. Plasma Sci. 7, 120–131. https://doi.org/10.1109/TPS.1979.4317207
}
