% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector.R
\name{chosenFew}
\alias{chosenFew}
\title{Print the chosen few items of a long vector}
\usage{
chosenFew(vec, start = 3, end = 1, collapse = ",")
}
\arguments{
\item{vec}{A vector of characters or other types that can be cast into
characters}

\item{start}{Integer, how many elements at the start shall be printed}

\item{end}{Integer, how many elements at the end shall be printed}

\item{collapse}{Character used to separate elements}
}
\value{
A character string ready to be printed
}
\description{
Print the chosen few (the first and the last) items of a long vector
}
\note{
In case the vector is shorter than the sum of \code{start} and
\code{end}, the whole vector is printed.
}
\examples{

lvec1 <- 1:100
chosenFew(lvec1)
chosenFew(lvec1, start=5, end=3)

svec <- 1:8
chosenFew(svec)
chosenFew(svec, start=5, end=4)

}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
