% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rocheCompound.R
\name{isRocheCompoundID}
\alias{isRocheCompoundID}
\title{Tell whether a character string is a Roche compound ID}
\usage{
isRocheCompoundID(str)
}
\arguments{
\item{str}{Character string(s)}
}
\value{
A logical vector of the same length as \code{str}, indicating whether each element is a Roche compound ID or not.
}
\description{
Tell whether a character string is a Roche compound ID
}
\note{
Short versions (RO[1-9]\{2,7\}) are supported.
}
\examples{
isRocheCompoundID(c("RO1234567", "RO-1234567", 
                   "RO1234567-000", "RO1234567-000-000",
                   "ROnoise-000-000"))
}
