% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfmat.R
\name{isTopOrIncAndNotExcl}
\alias{isTopOrIncAndNotExcl}
\title{Logical vector of being top or included and not excluded}
\usage{
isTopOrIncAndNotExcl(x, top = 1, incFunc, excFunc, decreasing = TRUE)
}
\arguments{
\item{x}{An atomic vector that can be sorted by \code{sort}, for instance integers and character strings.}

\item{top}{Integer, number of top elements that we want to consider.}

\item{incFunc}{Function, applied to \code{x} to return a logical vector of the same length, indicating whether the values should be included even if it does not belong to the top elements.}

\item{excFunc}{Function, applied to \code{x} to return a logical vector of the same length, indicating whether the values should be excluded even if it does belong to the top elements.}

\item{decreasing}{Logical, passed to \code{sort}. The default value is set to
\code{TRUE}, which means that the highest values are considered the top
elements. If set to \code{FALSE}, the lowest values are considered the top elements.}
}
\value{
A logical vector of the same length as the input \code{x}, indicating whether each element is being either top or included, and not excluded.
The function can be used to keep top elements of a vector while considering both inclusion and exclusion criteria.
}
\description{
Logical vector of being top or included and not excluded
}
\examples{
myVal <- c(2, 4, 8, 7, 1)
isTopOrIncAndNotExcl(myVal, top=1)
isTopOrIncAndNotExcl(myVal, top=3)
isTopOrIncAndNotExcl(myVal, top=3, incFunc=function(x) x>=2)
isTopOrIncAndNotExcl(myVal, top=3, excFunc=function(x) x\%\%2==1)
isTopOrIncAndNotExcl(myVal, top=3, incFunc=function(x) x>=2, excFunc=function(x) x\%\%2==1)
myVal2 <- c("a", "A", "a", "A", "A")
isTopOrIncAndNotExcl(myVal2, 2)
isTopOrIncAndNotExcl(myVal2, 2, incFunc=function(x) x=="A")
isTopOrIncAndNotExcl(myVal2, 4)
isTopOrIncAndNotExcl(myVal2, 4, excFunc=function(x) x=="a")
\donttest{
## the function returns all TRUEs if top is larger than the length of the vector
isTopOrIncAndNotExcl(myVal, top=9)
}
}
