% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midentical.R
\name{midentical}
\alias{midentical}
\title{Multiple identical}
\usage{
midentical(
  ...,
  num.eq = TRUE,
  single.NA = TRUE,
  attrib.as.set = TRUE,
  ignore.bytecode = TRUE,
  ignore.environment = FALSE,
  ignore.srcref = TRUE,
  extptr.as.ref = FALSE
)
}
\arguments{
\item{\dots}{Objects to be tested, or a list of them}

\item{num.eq, single.NA, attrib.as.set, ignore.bytecode, }{See
\code{\link{identical}}}

\item{ignore.environment, ignore.srcref}{See \code{\link{identical}}}

\item{extptr.as.ref}{See \code{\link{identical}}, new parameter since R-4.2}
}
\value{
A logical value, \code{TRUE} if all objects are identical
}
\description{
Testing whether multiple objects are identical
}
\details{
\code{midentical} extends \code{identical} to test multiple objects instead
of only two.
}
\examples{

set1 <- "HSV"
set2 <- set3 <- set4 <- c("HSV", "FCB")

midentical(set1, set2)
midentical(list(set1, set2))

midentical(set2, set3, set4)
midentical(list(set2, set3, set4))

## other options passed to identical
midentical(0, -0, +0, num.eq=FALSE)
midentical(0, -0, +0, num.eq=TRUE)

}
\seealso{
\code{identical}
}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
