% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaccardIndex.R
\name{pairwiseJaccardIndex}
\alias{pairwiseJaccardIndex}
\alias{pairwiseJaccardDistance}
\title{Calculate pairwise Jaccard Indices between each pair of items in a list}
\usage{
pairwiseJaccardIndex(list)

pairwiseJaccardDistance(list)
}
\arguments{
\item{list}{A list}
}
\value{
A symmetric matrix of dimension \code{mxm}, where \code{m} is the
length of the list

\code{pairwiseJaccardDistance} is defined as \code{1-pairwiseJaccardIndex}.
}
\description{
Calculate pairwise Jaccard Indices between each pair of items in a list
}
\examples{

myList <- list(first=LETTERS[3:5], second=LETTERS[1:3], third=LETTERS[1:5], fourth=LETTERS[6:10])
pairwiseJaccardIndex(myList)

poormanPJI <- function(list) {
  sapply(list, function(x) sapply(list, function(y) jaccardIndex(x,y)))
}
stopifnot(identical(pairwiseJaccardIndex(myList), poormanPJI(myList)))

}
