% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pScore.R
\name{replaceZeroPvalue}
\alias{replaceZeroPvalue}
\title{Replace p-values of zero}
\usage{
replaceZeroPvalue(p, factor = 1)
}
\arguments{
\item{p}{A numeric vector, containing p-values. Zero values will be replaced by a small, non-zero value.}

\item{factor}{A numeric vector, the minimal p-value will be multiplied by it. Useful for \code{pQnormScore}, because there the p-value needs to be divided by two, therefore a factor of two makes sense.}
}
\value{
A numeric vector of the same length as the input vector, with zeros replaced by the minimal absolute double value defined by the machine multiplied by the factor.
}
\description{
Replace p-values of zero
}
\note{
Values under the minimal positive double value are considered zero and replaced.
}
\examples{
ps <- seq(0,1,0.1)
replaceZeroPvalue(ps)
replaceZeroPvalue(ps, factor=2)
}
