% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor.R
\name{as.array.tensor}
\alias{as.array.tensor}
\title{Strip array labels}
\usage{
\method{as.array}{tensor}(
  x,
  index_order = NULL,
  ...,
  arg = "index_order",
  call = rlang::caller_env()
)
}
\arguments{
\item{x}{A labeled array ("tensor" object) created by \code{\link{\%_\%}} or \code{\link[=tensor]{tensor()}}.}

\item{index_order}{An index specification created with \code{\link[=.]{.()}}.
The specification needs to match all the labels occurring in \code{x}.
The label order determines the dimension
order of the resulting array.}

\item{...}{Not used.}

\item{arg, call}{Used for error handling. Can be ignored by the user.}
}
\value{
The tensor components as usual \code{\link[=array]{array()}} object without any index labels
attached.
}
\description{
Converts a \code{\link[=tensor]{tensor()}} to an \code{\link[=array]{array()}} by stripping the index labels.
An index label order
needs to be provided so that the array's \code{\link[=dim]{dim()}} order is well defined.
}
\examples{
array(1:8, dim = c(2, 2, 2)) \%_\% .(i, +i, k) |> as.array(.(k))
}
\concept{tensor_dest}
