% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect.R
\name{expect_tensor_equal}
\alias{expect_tensor_equal}
\title{Does code return the expected value?}
\usage{
expect_tensor_equal(object, expected, ...)
}
\arguments{
\item{object, expected}{Computation and value to compare it to.

Both arguments supports limited unquoting to make it easier to generate
readable failures within a function or for loop. See \link[testthat]{quasi_label} for
more details.}

\item{...}{
  Arguments passed on to \code{\link[waldo:compare]{waldo::compare}}
  \describe{
    \item{\code{tolerance}}{If non-\code{NULL}, used as threshold for ignoring small
floating point difference when comparing numeric vectors. Using any
non-\code{NULL} value will cause integer and double vectors to be compared
based on their values, not their types, and will ignore the difference
between \code{NaN} and \code{NA_real_}.

It uses the same algorithm as \code{\link[=all.equal]{all.equal()}}, i.e., first we generate
\code{x_diff} and \code{y_diff} by subsetting \code{x} and \code{y} to look only locations
with differences. Then we check that
\code{mean(abs(x_diff - y_diff)) / mean(abs(y_diff))} (or just
\code{mean(abs(x_diff - y_diff))} if \code{y_diff} is small) is less than
\code{tolerance}.}
    \item{\code{max_diffs}}{Control the maximum number of differences shown. The
default shows 10 differences when run interactively and all differences
when run in CI. Set \code{max_diffs = Inf} to see all differences.}
    \item{\code{ignore_srcref}}{Ignore differences in function \code{srcref}s? \code{TRUE} by
default since the \code{srcref} does not change the behaviour of a function,
only its printed representation.}
    \item{\code{ignore_encoding}}{Ignore string encoding? \code{TRUE} by default, because
this is R's default behaviour. Use \code{FALSE} when specifically concerned
with the encoding, not just the value of the string.}
  }}
}
\value{
The actual value invisibly.
}
\description{
Adds an expectation function that can be used with the
\href{https://testthat.r-lib.org/}{testthat} package.
Compares two tensors and determines whether they are equal or not.
}
