% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{draw.contamination}
\alias{draw.contamination}
\title{Draw contamination impacts}
\usage{
draw.contamination(
  from = 0,
  to = 50000,
  ka = TRUE,
  age.res = 500,
  xlim = c(),
  ylim = c(),
  colours = rainbow(age.res),
  max.contam = 0.1,
  contam.F14C = 1,
  contam.legend = max.contam * c(1/100, (1:5)/50, (1:4)/5, 1),
  legend.pos = 0.07,
  legend.cex = 0.6,
  grid = TRUE,
  xaxs = "i",
  yaxs = "i"
)
}
\arguments{
\item{from}{Minimum 14C age for the plot. Defaults to 0.}

\item{to}{Maximum 14C age for the plot. Defaults to 50e3.}

\item{ka}{Use C14 kBP. Defaults to TRUE.}

\item{age.res}{Resolution of age scale. Defaults to 500, which results in smooth curves. Higher numbers will take longer to draw.}

\item{xlim}{Limits of the horizontal axis.}

\item{ylim}{Limits of the vertical axis.}

\item{colours}{Colours of the percentages. Defaults to rainbow colours.}

\item{max.contam}{Maximum contamination level as a fraction of the sample. Defaults to 0.1 (10\%).}

\item{contam.F14C}{14C activity of the sample. Defaults to 'modern' 14C, F14C=1.}

\item{contam.legend}{Percentages for which numbers will be plotted.}

\item{legend.pos}{horizontal position beyond which the percentage values will be plotted}

\item{legend.cex}{font size of the legend}

\item{grid}{Whether to plot a grid. Defaults to TRUE}

\item{xaxs}{Whether or not to extend the limits of the horizontal axis. Defaults to \code{xaxs="i"} which does not extend.}

\item{yaxs}{Whether or not to extend the limits of the vertical axis. Defaults to \code{yaxs="i"} which does not extend.}
}
\value{
A plot of real and observed (contamination-impacted) C14 ages.
}
\description{
Show how contamination with different fractions of modern carbon affect observed C-14 ages.
}
\examples{
  draw.contamination()
  draw.contamination(40e3, 50e3, ka=FALSE)
}
