% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timescales.R
\name{CtoF}
\alias{CtoF}
\title{Calculate F14C values from C14 ages}
\usage{
CtoF(y, er = NULL, roundby = Inf, lambda = 8033, botherrors = FALSE)
}
\arguments{
\item{y}{Reported mean of the 14C age.}

\item{er}{Reported error of the 14C age. If left empty, will translate y to F14C.}

\item{roundby}{Amount of decimals required for the output. Defaults to \code{roundby=Inf}, no rounding.}

\item{lambda}{The mean-life of radiocarbon (based on Libby half-life of 5568 years).}

\item{botherrors}{Since going from C14 to F14C involves a logarithmic transformation (F=exp(-y/lambda)), errors that are symmetric on the C14 scale will become asymmetric on the F14C scale. By default, only the largest error is reported, but if \code{botherrors=TRUE}, both errors are reported.}
}
\value{
F14C values from C14 ages.
}
\description{
Calculate F14C values from radiocarbon ages
}
\details{
Post-bomb dates are often reported as F14C or fraction modern carbon. Since software such as Bacon expects radiocarbon ages,
this function can be used to calculate F14C values from radiocarbon ages. The reverse function of \link{F14C.age}. This function is a shortcut to C14toF14C.
}
\examples{
  CtoF(-2000, 20)
}
