% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel_config.R
\name{should_parallelize}
\alias{should_parallelize}
\title{Decide Whether to Use Parallel Processing}
\usage{
should_parallelize(n, threshold = 10)
}
\arguments{
\item{n}{Integer specifying the number of items to process.}

\item{threshold}{Integer specifying the minimum number of items required
for parallel processing to be beneficial (default: 10).
Below this threshold, sequential processing is used even if parallelization is enabled.}
}
\value{
Logical value: \code{TRUE} if parallel processing should be used, \code{FALSE} otherwise.
}
\description{
Internal function to determine if an operation should use parallel processing
based on the number of items to process and current configuration.
}
\details{
This function returns \code{TRUE} only if:
\enumerate{
\item Parallel processing is enabled (via \code{set_parallel_plan()})
\item The number of items \code{n} is at least \code{threshold}
}

For small numbers of items, the overhead of parallelization typically outweighs the benefits,
so sequential processing is used.
}
\examples{
\dontrun{
# With parallel processing enabled
set_parallel_plan("multisession")
should_parallelize(5)    # FALSE (below threshold)
should_parallelize(20)   # TRUE (above threshold)

# With parallel processing disabled
set_parallel_plan("sequential")
should_parallelize(100)  # FALSE (sequential plan)
}

}
\seealso{
\code{\link[=set_parallel_plan]{set_parallel_plan()}}, \code{\link[=is_parallel_enabled]{is_parallel_enabled()}}
}
