% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regress_utils.R
\name{predict.uRegress}
\alias{predict.uRegress}
\alias{predict}
\title{Prediction Intervals for \code{uRegress} objects}
\usage{
\method{predict}{uRegress}(object, interval = "prediction", level = 0.95, ...)
}
\arguments{
\item{object}{an object of class \code{uRegress}.}

\item{interval}{Type of interval calculation}

\item{level}{Tolerance/confidence level}

\item{...}{other arguments to pass to the appropriate predict function for
the class of \code{object$fit}. See \code{\link[stats]{predict.lm}}, 
or \code{\link[stats]{predict.glm}} for
more details.}
}
\value{
Returns a matrix with the fitted
value and prediction interval for the entered X.
}
\description{
Produces prediction intervals for objects of class \code{uRegress}.
}
\examples{

# Loading required libraries
library(survival)
library(sandwich)

# Reading in a dataset
data(mri)

# Linear regression of LDL on age (with robust SE by default)
testReg <- regress ("mean", ldl~age, data = mri)

# 95\% Prediction Interval for age 50
predict(testReg)

}
\seealso{
\code{\link[rigr]{regress}}
}
