% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_functions.R
\name{predict_rinet_1d}
\alias{predict_rinet_1d}
\title{Predict statistics of the underlying reference distribution from 1D mixture distributions using RINet}
\usage{
predict_rinet_1d(
  data,
  feature_grid_range = c(-4, 4),
  feature_grid_nbins = 100,
  verbose = 0,
  log_scale = TRUE,
  percentiles = c(0.025, 0.975),
  n_bootstrap = 0,
  confidence_level = 0.95
)
}
\arguments{
\item{data}{A numeric vector, matrix, or list of vectors. Each sample should
contain observations from a 1D mixture distribution.}

\item{feature_grid_range}{Numeric vector of length 2 specifying the range
for histogram binning. Default is c(-4, 4).}

\item{feature_grid_nbins}{Integer specifying the number of histogram bins.
Default is 100.}

\item{verbose}{Integer controlling verbosity (0 = silent). Default is 0.}

\item{log_scale}{Logical indicating whether to log-transform the data before
prediction. If TRUE (default), returns log-scale statistics and calculates
reference intervals in the original scale. Default is TRUE.}

\item{percentiles}{Numeric vector of length 2 specifying the lower and upper
percentiles for the reference interval. Default is c(0.025, 0.975).}

\item{n_bootstrap}{Integer specifying the number of bootstrap resamples for
confidence intervals. Default is 0 (no bootstrap). When > 0, confidence
intervals are computed for all predicted statistics.}

\item{confidence_level}{Numeric specifying the confidence level for bootstrap
intervals. Default is 0.95.}
}
\value{
A list of predictions. Each element contains:
  \item{mean}{Predicted mean (scalar, log-scale if log_scale=TRUE)}
  \item{std}{Predicted standard deviation (scalar, log-scale if log_scale=TRUE)}
  \item{covariance}{Covariance matrix (1x1 matrix)}
  \item{correlation}{Always NA for 1D}
  \item{reference_fraction}{Predicted reference component fraction}
  \item{reference_interval}{Reference interval in original scale (if log_scale=TRUE)}
  \item{log_scale}{Logical indicating whether log-scaling was used}
  \item{bootstrap_ci}{List of bootstrap confidence intervals (if n_bootstrap > 0):
    mean_ci, std_ci, reference_fraction_ci, reference_interval_lower_ci,
    reference_interval_upper_ci}
}
\description{
Takes one or more 1D samples and predicts the underlying reference
population statistics (mean, std, reference fraction) from a mixture
of healthy and pathological measurements.
}
\examples{
\dontrun{
  # Single sample (using positive data for log-scale)
  sample1 <- exp(rnorm(1000, mean = 2, sd = 0.3))
  result <- predict_rinet_1d(sample1)
  print(result[[1]]$mean)

  # Multiple samples
  samples <- list(exp(rnorm(1000, 2, 0.3)), exp(rnorm(1000, 1.5, 0.4)))
  results <- predict_rinet_1d(samples)
}
}
