% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_get_call_data.R
\name{rs_get_call_data}
\alias{rs_get_call_data}
\title{Get calls data}
\usage{
rs_get_call_data(
  date_from = Sys.Date() - 14,
  date_to = Sys.time(),
  fields = c("caller", "dst", "pool_name", "disposition", "calldate", "category_mark",
    "duration", "call_type", "waittime", "billsec", "connected_with", "call_counter",
    "proper_flag", "repeated_flag", "utm_source", "utm_medium", "utm_campaign",
    "utm_content", "utm_term", "uniqueid", "category_number", "employee_number",
    "employee_mark", "client_id", "remote_ip", "refferrer", "landing", "recording",
    "recording_wav", "call_card", "additional_number", "has_recording", "scheme_name",
    "duration_ms", "department", 
     "caller_number"),
  filters = NULL,
  merge = 0,
  order = NULL
)
}
\arguments{
\item{date_from}{Start date}

\item{date_to}{End date}

\item{fields}{List of fields for selection from the call log, see \href{https://help.ringostat.com/knowledge-base/article/integration-with-ringostat-via-api#export_calllog_parameters}{link}}

\item{filters}{Filters for selecting data that meet a condition by field value}

\item{merge}{Aggregating the sample by the caller's number: 0 - do not combine; 1 - combine every 24 hours; 2 - combine for all time;}

\item{order}{Sorting a selection}
}
\value{
tibble with calls data
}
\description{
Get calls data
}
\examples{
\dontrun{
calls <- rs_get_call_data(
    date_from = "2021-09-01",
    date_to = "2021-09-30",
    fields = c('caller', 'utm_campaign'),
    filters = "utm_campaign=brand"
)
}

}
