% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capture_cran_warning.R
\name{capture_cran_warning}
\alias{capture_cran_warning}
\title{Capture CRAN URL warnings and errors}
\usage{
capture_cran_warning(cran_url, path)
}
\arguments{
\item{cran_url}{Character. Base URL of the CRAN mirror.}

\item{path}{Character. Path to the resource on the CRAN server.}
}
\value{
A list with two elements:
\describe{
  \item{status}{Character string indicating the result type: "success", "url_error", "timeout", "error", "url_warning", "timeout_warning", or "warning".}
  \item{message}{Character string with the captured warning or error message, or NULL if successful.}
}
}
\description{
This internal function attempts to open a CRAN URL and read its contents.
It captures and classifies warnings and errors related to network issues,
such as timeouts or inaccessible URLs.
}
\examples{
\dontrun{
  capture_cran_warning("http://cran.us.r-project.org", "src/contrib/Meta/archive.rds")
}
}
\keyword{internal}
