% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{get_score}
\alias{get_score}
\title{Calculate Score from Risk Probability}
\usage{
get_score(object, risk)
}
\arguments{
\item{object}{An object of class "risk_mod", usually a result of a call to
\code{\link[=risk_mod]{risk_mod()}}.}

\item{risk}{Numeric vector with probability value(s).}
}
\value{
Numeric vector with the same length as \code{risk}.
}
\description{
Returns the score(s) for the provided risk probabilities.
}
\examples{
y <- breastcancer[[1]]
X <- as.matrix(breastcancer[,2:ncol(breastcancer)])

mod <- risk_mod(X, y)
get_score(mod, risk = c(0.25, 0.50, 0.75))

}
