% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_prob_freq.R
\name{comp_prob_freq}
\alias{comp_prob_freq}
\title{Compute probabilities from (4 essential) frequencies.}
\usage{
comp_prob_freq(hi = freq$hi, mi = freq$mi, fa = freq$fa, cr = freq$cr)
}
\arguments{
\item{hi}{The number of hits \code{\link{hi}} (or true positives).}

\item{mi}{The number of misses \code{\link{mi}} (or false negatives).}

\item{fa}{The number of false alarms \code{\link{fa}} (or false positives).}

\item{cr}{The number of correct rejections \code{\link{cr}} (or true negatives).}
}
\description{
\code{comp_prob_freq} computes current probability information
from 4 essential frequencies
(\code{\link{hi}}, \code{\link{mi}}, \code{\link{fa}}, \code{\link{cr}}).
It returns a list of 11 frequencies \code{\link{freq}}
for a population of \code{\link{N}} individuals
as its output.
}
\details{
Key relationships between frequencies and probabilities
(see documentation of \code{\link{comp_freq}} or \code{\link{comp_prob}} for details):

\itemize{

  \item Three perspectives on a population:

  by condition / by decision / by accuracy.

  \item Defining probabilities in terms of frequencies:

  Probabilities can be computed as ratios between frequencies, but beware of rounding issues.

}


Functions translating between representational formats:
\code{\link{comp_prob_prob}}, \code{comp_prob_freq},
\code{\link{comp_freq_prob}}, \code{\link{comp_freq_freq}}
(see documentation of \code{\link{comp_prob_prob}} for details).
}
\examples{
## Basics:
comp_prob_freq()  # => computes prob from current freq

## Beware of rounding:
all.equal(prob, comp_prob_freq())  # => would be TRUE (IF freq were NOT rounded)!
fe <- comp_freq(round = FALSE)     # compute exact freq (not rounded)
all.equal(prob, comp_prob_freq(fe$hi, fe$mi, fe$fa, fe$cr))  # is TRUE (qed).

## Explain by circular chain (compute prob 1. from num and 2. from freq)
# 0. Inspect current numeric parameters:
num

# 1. Compute currently 11 probabilities in prob (from essential probabilities):
prob <- comp_prob()
prob

# 2. Compute currently 11 frequencies in freq (from essential probabilities):
freq <- comp_freq(round = FALSE)   # no rounding (to obtain same probabilities later)
freq

# 3. Compute currently 11 probabilities again (but now from frequencies):
prob_freq <- comp_prob_freq()
prob_freq

# 4. Check equality of probabilities (in steps 1. and 3.):
all.equal(prob, prob_freq)  # => should be TRUE!

}
\seealso{
\code{\link{comp_freq_freq}} computes current frequency information from (4 essential) frequencies;
\code{\link{comp_freq_prob}} computes current frequency information from (3 essential) probabilities;
\code{\link{comp_prob_prob}} computes current probability information from (3 essential) probabilities;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{is_prob}} verifies probability inputs;
\code{\link{is_freq}} verifies frequency inputs.

Other functions computing probabilities: 
\code{\link{comp_FDR}()},
\code{\link{comp_FOR}()},
\code{\link{comp_NPV}()},
\code{\link{comp_PPV}()},
\code{\link{comp_acc}()},
\code{\link{comp_accu_freq}()},
\code{\link{comp_accu_prob}()},
\code{\link{comp_comp_pair}()},
\code{\link{comp_complement}()},
\code{\link{comp_complete_prob_set}()},
\code{\link{comp_err}()},
\code{\link{comp_fart}()},
\code{\link{comp_mirt}()},
\code{\link{comp_ppod}()},
\code{\link{comp_prob}()},
\code{\link{comp_sens}()},
\code{\link{comp_spec}()}

Other format conversion functions: 
\code{\link{comp_freq_freq}()},
\code{\link{comp_freq_prob}()},
\code{\link{comp_prob_prob}()}
}
\concept{format conversion functions}
\concept{functions computing probabilities}
