% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/italic_occurrences.R
\name{italic_occurrences}
\alias{italic_occurrences}
\title{Get occurrence records for lichen taxa}
\usage{
italic_occurrences(sp_names, result_data = "simple")
}
\arguments{
\item{sp_names}{Character vector of accepted names}

\item{result_data}{Character string specifying output detail level:
"simple" (default) or "extended"}
}
\value{
A data frame with occurrence records. Column names follow the Darwin Core standard, with the additional column substratum, which is particularly relevant for lichens. For simple output:
\describe{
\item{scientificName}{The scientific name provided as input}
\item{decimalLatitude}{Latitude in decimal degrees}
\item{decimalLongitude}{Longitude in decimal degrees}
\item{coordinatesUncertaintyInMeters}{Spatial uncertainty of the coordinates}
\item{substratum}{Substrate on which the specimen was found}
\item{institutionCode}{Code of the herbarium holding the specimen}
\item{eventDate}{Collection date}
}

Extended output adds:
\describe{
\item{locality}{Collection locality}
\item{catalogNumber}{Specimen identifier in the collection}
\item{minimumElevationInMeters}{Lower limit of the elevation range}
\item{maximumElevationInMeters}{Upper limit of the elevation range}
\item{verbatimIdentification}{Scientific name reported on the original label}
\item{identifiedBy}{Person who identified the specimen}
}
}
\description{
Retrieves occurrence records from Italian herbarium collections for specified lichen taxa.
Only accepts names that exist in the database of ITALIC.
}
\note{
Before using this function with a list of names, first obtain their accepted names
using \code{italic_match()}.
Example workflow:
\preformatted{
      names_matched <- italic_match(your_names)
      occ <- italic_occurrences(names_matched$accepted_name)
      }
}
\examples{
\dontrun{
# Get simple occurrence data
italic_occurrences("Cetraria ericetorum Opiz")

# Get extended occurrence data
occ_ext <- italic_occurrences("Cetraria ericetorum Opiz", result_data = "extended")

# Then get citations for the retrieved occurrences
italic_occurrences_references(occ_ext)
}

}
\references{
ITALIC - The Information System on Italian Lichens
\url{https://italic.units.it}
}
