% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxp_make.R
\name{rxp_import_artifacts}
\alias{rxp_import_artifacts}
\title{Import Nix store paths from an archive}
\usage{
rxp_import_artifacts(archive_file = "_rixpress/pipeline_outputs.nar")
}
\arguments{
\item{archive_file}{Character, path to the archive, defaults to
"_rixpress/pipeline-outputs.nar"}
}
\value{
Nothing, imports the archive contents into the local Nix store.
}
\description{
Imports the store paths contained in an archive file into the local Nix store.
Useful for transferring built outputs between machines.
}
\examples{
\dontrun{
  # Import from the default archive location
  rxp_import_artifacts()

  # Import from a custom archive file
  rxp_import_artifacts("path/to/my_archive.nar")
}
}
\seealso{
Other archive caching functions: 
\code{\link{rxp_export_artifacts}()}
}
\concept{archive caching functions}
