/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import lombok.Generated;
import lombok.NonNull;

public enum TsInformationType {
    UserDefined(-1),
    None(0),
    Definition(1),
    MetaData(2),
    BaseInformation(3),
    Data(4),
    All(5);

    private final int value;

    public int toInt() {
        return this.value;
    }

    @NonNull
    public static TsInformationType parse(int value) throws IllegalArgumentException {
        for (TsInformationType o : TsInformationType.values()) {
            if (o.value != value) continue;
            return o;
        }
        throw new IllegalArgumentException("Cannot parse " + value);
    }

    public boolean needsData() {
        return this == Data || this == All;
    }

    public TsInformationType union(TsInformationType rtype) {
        if (this == UserDefined) {
            return UserDefined;
        }
        if (this == rtype) {
            return this;
        }
        if (this == All || rtype == All) {
            return All;
        }
        if (this == None) {
            return rtype;
        }
        if (rtype == None) {
            return this;
        }
        if (this == Data && rtype == Definition) {
            return Data;
        }
        if (this == Definition && rtype == Data) {
            return Data;
        }
        return All;
    }

    public boolean encompass(TsInformationType newtype) {
        if (this == UserDefined) {
            return true;
        }
        switch (newtype.ordinal()) {
            case 6: {
                return this == All;
            }
            case 5: {
                return this == Data || this == All;
            }
            case 3: {
                return this == MetaData || this == All;
            }
            case 2: {
                return this == All || this == Data || this == Definition;
            }
        }
        return true;
    }

    public boolean hasData() {
        switch (this.ordinal()) {
            case 0: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public boolean hasMeta() {
        switch (this.ordinal()) {
            case 0: 
            case 3: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Generated
    private TsInformationType(int value) {
        this.value = value;
    }
}

