% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{lp_variable}
\alias{lp_variable}
\title{Leap Year regressor}
\usage{
lp_variable(
  frequency,
  start,
  length,
  s,
  type = c("LeapYear", "LengthOfPeriod")
)
}
\arguments{
\item{frequency}{Frequency of the series, number of periods per year
(12, 4, 3, 2...)}

\item{start, length}{First date (array with the first year and the first
period, for instance \code{c(1980, 1)}) and number of periods of the output
variables. Can also be provided with the \code{s} argument}

\item{s}{time series used to get the dates for the trading days variables.
If supplied the parameters \code{frequency}, \code{start} and \code{length} are ignored.}

\item{type}{the modelling of the leap year effect: as a contrast variable (\code{type = "LeapYear"}, default)
or by a length-of-month (or length-of-quarter; \code{type = "LengthOfPeriod"}).}
}
\value{
Time series (object of class \code{"ts"})
}
\description{
Allows to generate a regressor correcting for the leap year or length-of-period effect.
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
# Leap years occur in year 2000, 2004, 2008 and 2012
lp_variable(4, start = c(2000, 1), length = 4 * 13)
lper <- lp_variable(12, c(2000, 1), length = 10 * 12, type = "LengthOfPeriod")
\dontshow{\}) # examplesIf}
}
\references{
More information on calendar correction in JDemetra+ online documentation:
\url{https://jdemetra-new-documentation.netlify.app/a-calendar-correction}
}
\seealso{
\code{\link{calendar_td}}
}
