% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modellingcontext.R
\name{modelling_context}
\alias{modelling_context}
\title{Create modelling context}
\usage{
modelling_context(calendars = NULL, variables = NULL)
}
\arguments{
\item{calendars}{list of calendars.}

\item{variables}{list of variables.}
}
\value{
list of calendars and variables
}
\description{
Function allowing to include calendars and external regressors in a format that makes them usable
in an estimation process (reg-arima or tramo modelling, stand alone or as pre-processing in seasonal adjustment).
The regressors can be created with functions available in the package
or come from any other source, provided they are \code{ts} class objects.
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}

# Creating one or several external regressors (TS objects), which will
# be gathered in one or several groups
iv1 <- intervention_variable(12, c(2000, 1), 60,
    starts = "2001-01-01", ends = "2001-12-01"
)
iv2 <- intervention_variable(12, c(2000, 1), 60,
    starts = "2001-01-01", ends = "2001-12-01", delta = 1
)

# Regressors as a list of two groups reg1 and reg2
vars <- list(reg1 = list(x = iv1), reg2 = list(x = iv2))

# Creating the modelling context
my_context <- modelling_context(variables = vars)
\dontshow{\}) # examplesIf}
}
\references{
More information on auxiliary variables in JDemetra+ online documentation:
\url{https://jdemetra-new-documentation.netlify.app/}
}
\seealso{
\code{\link{add_usrdefvar}}, \code{\link{intervention_variable}}
}
