% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkStatus.R
\name{cancelJob}
\alias{cancelJob}
\title{Cancel an active LANDFIRE Product Service (LFPS) API job}
\usage{
cancelJob(job_id)
}
\arguments{
\item{job_id}{The job ID of the LFPS API request as a character string}
}
\value{
NULL. Prints a message to the console about the job status.
}
\description{
\code{cancelJob()} sends a request to cancel a LFPS API request
}
\examples{
\dontrun{
products <-  c("ASP2020", "ELEV2020", "230CC")
aoi <- c("-123.7835", "41.7534", "-123.6352", "41.8042")
email <- "email@example.com>"

resp <- landfireAPIv2(products, aoi, email, background = TRUE)

job_id <- resp$request$job_id #Get job_id from a previous request
cancelJob("job_id")
}
}
