% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kde.R
\name{kde}
\alias{kde}
\title{Univariate kernel density}
\usage{
kde(x.obs, x.new = NULL, h)
}
\arguments{
\item{x.obs}{Training (observed) data (n1 vector)}

\item{x.new}{Evaluation data (n2 vector); default to x.obs}

\item{h}{Bandwidth}
}
\value{
Density evaluated at x.new
}
\description{
Univariate kernel density
}
\examples{
x=rnorm(100)
x.new=seq(-5,5,length=50)
h=1.06*sd(x)*(length(x))^(-1/5)
f=kde(x.new=x.new,x.obs=x,h=h)
}
\references{
Wu, Ximing (2019), "Robust Likelihood Cross Validation for Kernel Density Estimation," Journal of Business and Economic Statistics, 37(4): 761-770.
}
\author{
Ximing Wu \email{xwu@tamu.edu}
}
