% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizeNewParam.R
\name{optimizeNewLambda}
\alias{optimizeNewLambda}
\title{Perform factorization for new lambda value}
\usage{
optimizeNewLambda(
  object,
  lambdaNew,
  nIteration = 30,
  seed = 1,
  verbose = getOption("ligerVerbose"),
  new.lambda = lambdaNew,
  max.iters = nIteration,
  rand.seed = seed,
  thresh = NULL
)
}
\arguments{
\item{object}{\linkS4class{liger} object. Should have integrative
factorization (e.g. \code{\link{runINMF}}) performed in advance.}

\item{lambdaNew}{Numeric regularization parameter. Larger values penalize
dataset-specific effects more strongly.}

\item{nIteration}{Number of block coordinate descent iterations to
perform. Default \code{30}.}

\item{seed}{Random seed to allow reproducible results. Default \code{1}. Used
by \code{\link{runINMF}} factorization.}

\item{verbose}{Logical. Whether to show information of the progress. Default
\code{getOption("ligerVerbose")} which is \code{TRUE} if users have not set.}

\item{new.lambda, max.iters, rand.seed}{These arguments are now replaced by
others and will be removed in the future. Please see usage for replacement.}

\item{thresh}{\bold{Deprecated}. New implementation of iNMF does not require
a threshold for convergence detection. Setting a large enough
\code{nIteration} will bring it to convergence.}
}
\value{
Input \code{object} with optimized factorization values updated.
including the \code{W} matrix in \linkS4class{liger} object, and \code{H} and
\code{V} matrices in each \linkS4class{ligerDataset} object in the
\code{datasets} slot.
}
\description{
Uses an efficient strategy for updating that takes advantage of
the information in the existing factorization; always uses previous k.
Recommended mainly when re-optimizing for higher lambda and when new lambda
value is significantly different; otherwise may not return optimal results.
}
\examples{
pbmc <- normalize(pbmc)
pbmc <- selectGenes(pbmc)
pbmc <- scaleNotCenter(pbmc)
if (requireNamespace("RcppPlanc", quietly = TRUE)) {
    # Only running a few iterations for fast examples
    pbmc <- runINMF(pbmc, k = 20, nIteration = 2)
    # pbmc <- optimizeNewLambda(pbmc, lambdaNew = 5.5, nIteration = 2)
}
}
\seealso{
\code{\link{runINMF}}, \code{\link{optimizeNewK}},
\code{\link{optimizeNewData}}
}
