% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_units.R
\name{get_units}
\alias{get_units}
\title{Retrieve Macrostrat unit data}
\usage{
get_units(
  unit_id = NULL,
  section_id = NULL,
  column_id = NULL,
  strat_name = NULL,
  strat_name_id = NULL,
  interval_name = NULL,
  interval_id = NULL,
  age = NULL,
  age_top = NULL,
  age_bottom = NULL,
  lat = NULL,
  lng = NULL,
  lithology = NULL,
  lithology_id = NULL,
  lithology_group = NULL,
  lithology_type = NULL,
  lithology_class = NULL,
  lithology_att = NULL,
  lithology_att_id = NULL,
  lithology_att_type = NULL,
  environ = NULL,
  environ_id = NULL,
  environ_type = NULL,
  environ_class = NULL,
  pbdb_collection_no = NULL,
  econ = NULL,
  econ_id = NULL,
  econ_type = NULL,
  econ_class = NULL,
  project_id = NULL,
  adjacents = FALSE,
  sf = FALSE
)
}
\arguments{
\item{unit_id}{\code{integer}. Filter units by their unique identification
number(s).}

\item{section_id}{\code{integer}. Filter units to those contained within
section(s) as specified by their unique identification number(s).}

\item{column_id}{\code{integer}. Filter units to those contained within
column(s) as specified by their unique identification number(s).}

\item{strat_name}{\code{character}. Filter units to those containing a unit
that fuzzy matches a stratigraphic name (e.g., "Hell Creek").}

\item{strat_name_id}{\code{integer}. Filter units to those that match one
or more stratigraphic name(s) as specified by their unique identification
number(s).}

\item{interval_name}{\code{character}. Filter units to those that overlap
with a named chronostratigraphic time interval (e.g., "Permian").}

\item{interval_id}{\code{integer}. Filter units to those that overlap with
one or more chronostratigraphic time interval(s) as specified by their
unique identification number(s).}

\item{age}{\code{numeric}. Filter units to those that overlap with the
specified numerical age, in millions of years before present.}

\item{age_top}{\code{numeric}. Filter units to those that overlap with the
age range between the specified numerical age and \code{age_bottom}. Should be
in millions of years before present. \code{age_bottom} must also be specified,
and \code{age_top} must be younger than \code{age_bottom}.}

\item{age_bottom}{\code{numeric}. Filter units to those that overlap with
the age range between the specified numerical age and \code{age_top}. Should
be in millions of years before present. \code{age_top} must also be specified,
and \code{age_bottom} must be older than \code{age_top}.}

\item{lat}{\code{numeric}. Return the units at the specified decimal degree
latitude. Must also specify \code{lng}.}

\item{lng}{\code{numeric}. Return the units at the specified decimal degree
longitude. Must also specify \code{lat}.}

\item{lithology}{\code{character}. Filter units to those containing a named
lithology (e.g., "shale", "sandstone").}

\item{lithology_id}{\code{integer}. Filter units to those containing one or
more lithology(ies) as specified by their unique identification
number(s).}

\item{lithology_group}{\code{character}. Filter units to those containing a
named lithology group (e.g., "sandstones", "mudrocks", "unconsolidated").}

\item{lithology_type}{\code{character}. Filter units to those containing a
named lithology type (e.g., "carbonate", "siliciclastic").}

\item{lithology_class}{\code{character}. Filter units to those containing a
named lithology class (e.g., "sedimentary", "igneous", "metamorphic").}

\item{lithology_att}{\code{character}. Filter units to those containing a
named lithology attribute (e.g., "fine", "olivine", "poorly washed").}

\item{lithology_att_id}{\code{integer}. Filter units to those containing
one or more lithology attribute(s) as specified by their unique
identification number(s).}

\item{lithology_att_type}{\code{character}. Filter units to those
containing a named category of lithology attribute (e.g., "grains",
"lithology", "bedform").}

\item{environ}{\code{character}. Filter units to those containing a named
environment (e.g., "delta plain", "pond").}

\item{environ_id}{\code{integer}. Filter units to those containing one or
more environment(s) as specified by their unique identification
number(s).}

\item{environ_type}{\code{character}. Filter units to those containing a
named environment type (e.g., "fluvial", "eolian", "glacial").}

\item{environ_class}{\code{character}. Filter units to those containing a
named environment class (e.g., "marine", "non-marine").}

\item{pbdb_collection_no}{\code{integer}. Filter units to those containing
one or more Paleobiology Database collection(s) as specified by their
unique identification number(s).}

\item{econ}{\code{character}. Filter units to those containing a named
economic attribute (e.g., "brick", "ground water", "gold").}

\item{econ_id}{\code{integer}. Filter units to those containing one or more
economic attribute(s) as specified by their unique identification
number(s).}

\item{econ_type}{\code{character}. Filter units to those containing a named
economic attribute type (e.g., "construction", "aquifer", "mineral").}

\item{econ_class}{\code{character}. Filter units to those containing a
named economic attribute class (e.g., "material", "water", "precious
commodity").}

\item{project_id}{\code{integer}. Filter units to those contained within
one or more Macrostrat project(s) as specified by their unique
identification number(s).}

\item{adjacents}{\code{logical}. If \code{column_id} or \code{lat}/\code{lng} is
specified, should all units that touch the specified column be returned?
Defaults to \code{FALSE}.}

\item{sf}{\code{logical}. Should the results be returned as an \code{sf} object?
Defaults to \code{FALSE}.}
}
\value{
A \code{data.frame} containing the following columns:
\itemize{
\item \code{unit_id}: The unique identification number of the Macrostrat
unit.
\item \code{section_id}: The unique identification number of the
Macrostrat section containing the unit.
\item \code{col_id}: The unique identification number of the Macrostrat
column containing the unit.
\item \code{project_id}: The unique identification number of the
Macrostrat project.
\item \code{col_area}: The area of the associated Macrostrat column in
km\ifelse{html}{\out{<sup>2</sup>}}{\eqn{^2}}.
\item \code{unit_name}: The name of the Macrostrat unit.
\item \code{strat_name_id}: The unique Macrostrat stratigraphic name ID.
\item \code{Mbr}: The lithostratigraphic member.
\item \code{Fm}: The lithostratigraphic formation.
\item \code{Gp}: The lithostratigraphic group.
\item \code{SGp}: The lithostratigraphic supergroup.
\item \code{t_age}: The age of the top of the unit, estimated using the
continuous time age model, in millions of years before present.
\item \code{b_age}: The age of the bottom of the unit, estimated using the
continuous time age model, in millions of years before present.
\item \code{max_thick}: The maximum thickness of the unit, in meters.
\item \code{min_thick}: The minimum thickness of the unit, in meters.
\item \code{outcrop}: Type of exposure ("outcrop", "subsurface", or
"both").
\item \code{pbdb_collections}: The number of Paleobiology Database
collections contained within the unit.
\item \code{pbdb_occurrences}: The number of Paleobiology Database
occurrences contained within the unit.
\item \code{lith}: a \code{dataframe} containing the lithologies present
within the unit, with the following columns:
\itemize{
\item \code{name}: The named lithology (e.g., "sandstone").
\item \code{prop}: The proportion of the lithology within the unit,
calculated from the individual Macrostrat sub-units within the unit.
\item \code{lith_id}: The unique identification number of the
lithology.
\item \code{type}: The named lithology type (e.g., "siliciclastic").
\item \code{class}: The named lithology class (e.g., "sedimentary").
}
\item \code{environ}: a \code{dataframe} containing the environments
present within the unit, with the following columns:
\itemize{
\item \code{class}: The named environment class (e.g., "marine").
\item \code{type}: The named environment type (e.g., "siliciclastic").
\item \code{name}: The named environment (e.g., "delta plain").
\item \code{environ_id}: The unique identification number of the
environment.
}
\item \code{econ}: a \code{dataframe} containing the economic
attributes present within the unit, with the following columns:
\itemize{
\item \code{type}: The named economic attribute type (e.g.,
"mineral").
\item \code{name}: The named economic attribute (e.g., "gold").
\item \code{econ_id}: The unique identification number of the economic
attribute.
\item \code{class}: The named economic attribute class (e.g.,
"precious commodity").
}
\item \code{measure}: a \code{dataframe} containing the measure
attributes present within the unit, with the following columns:
\itemize{
\item \code{measure_class}: The class of measures (e.g.,
"geochemical").
\item \code{measure_type}: the type of measures (e.g., "minor
elements").
}
\item \code{notes}: Unit specific notes.
\item \code{color}: Recommended coloring for units based on dominant
lithology.
\item \code{text_color}: Recommended coloring for text based on color.
\item \code{t_int_id}: The ID of the chronostratigraphic interval
containing the top boundary of the unit.
\item \code{t_int_name}: The name of the time interval represented at
the top of the unit.
\item \code{t_int_age}: The age of the chronostratigraphic interval
containing the top boundary of the unit.
\item \code{t_prop}: Position of continuous time age model top boundary,
proportional to reference time interval (t_int_name).
\item \code{units_above}: The unit_ids of the units contacting the top
of the unit.
\item \code{b_int_id}: The ID of the chronostratigraphic interval
containing the bottom boundary of the unit.
\item \code{b_int_name}: The name of the time interval represented at
the bottom of the unit.
\item \code{b_int_age}: The age of the chronostratigraphic interval
containing the bottom boundary of the unit.
\item \code{b_prop}: Position of continuous time age model bottom
boundary, proportional to reference time interval (b_interval).
\item \code{units_below}: The unit_ids of the units contacting the
bottom of the unit.
\item \code{strat_name_long}: The stratigraphic name associated with
the unit (e.g., "Coal Valley Formation").
\item \code{refs}: The unique identification number(s) of the reference(s)
associated with the unit.
\item \code{clat}: The present day latitude of the centroid of the
column to which the unit belongs.
\item \code{clng}: The present day longitude of the centroid of the
column to which the unit belongs.
\item \code{t_plat}: The paleolatitude of the centroid of the column
which the unit belongs to at top age (\code{clat} rotated to \code{t_age}).
\item \code{t_plng}: The paleolongitude of the centroid of the column
which the unit belongs to at top age (\code{clng} rotated to \code{t_age}) .
\item \code{b_plat}: The paleolatitude of the centroid of the column
which the unit belongs to at bottom age (\code{clat} rotated to \code{b_age}).
\item \code{b_plng}: The paleolongitude of the the centroid of the
column which the unit belongs to at bottom age (\code{clng} rotated to
\code{b_age}).
}
If \code{sf} is \code{TRUE}, an \code{sf} object is returned instead, with a "geometry"
column that contains the spatial data instead of the \code{clat}/\code{clng} columns.
}
\description{
A function to retrieve Macrostrat unit data matching a
user-specified search criteria.
}
\details{
More information can be found for the inputs for this function
using the definition functions (beginning with \code{def_}).
}
\section{Developer(s)}{

Lewis A. Jones
}

\section{Reviewer(s)}{

William Gearty
}

\examples{
\donttest{
# Get units with a specific stratigraphic name
ex1 <- get_units(strat_name = "Hell Creek")
# Get units at a specific geographic coordinate
ex2 <- get_units(lng = -110.9, lat = 48.4)
}
}
\seealso{
Macrostrat data entities:
\code{\link{def_columns}()},
\code{\link{get_age_model}()},
\code{\link{get_columns}()},
\code{\link{get_sections}()}
}
\concept{macrostrat}
