% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mzQC.R
\name{MzQCbaseQuality}
\alias{MzQCbaseQuality}
\alias{MzQCbaseQuality-class}
\title{Base class of runQuality/setQuality}
\description{
Base class of runQuality/setQuality

Base class of runQuality/setQuality
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{metadata}}{The metadata for this run/setQuality}

\item{\code{qualityMetrics}}{Array of MzQCqualityMetric objects}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MzQCbaseQuality-new}{\code{MzQCbaseQuality$new()}}
\item \href{#method-MzQCbaseQuality-isValid}{\code{MzQCbaseQuality$isValid()}}
\item \href{#method-MzQCbaseQuality-getMetric}{\code{MzQCbaseQuality$getMetric()}}
\item \href{#method-MzQCbaseQuality-toJSON}{\code{MzQCbaseQuality$toJSON()}}
\item \href{#method-MzQCbaseQuality-fromData}{\code{MzQCbaseQuality$fromData()}}
\item \href{#method-MzQCbaseQuality-clone}{\code{MzQCbaseQuality$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCbaseQuality-new"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCbaseQuality-new}{}}}
\subsection{Method \code{new()}}{
Constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCbaseQuality$new(metadata = MzQCmetadata$new(), qualityMetrics = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metadata}}{Optional MzQCmetadata value for initialization of field metadata}

\item{\code{qualityMetrics}}{Optional list value for initialization of field qualityMetrics}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCbaseQuality-isValid"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCbaseQuality-isValid}{}}}
\subsection{Method \code{isValid()}}{
Verifies validity of the object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCbaseQuality$isValid(context = "MzQCbaseQuality")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{context}}{Optional string describing location in mzQC structure that is used for more informative warning texts.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCbaseQuality-getMetric"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCbaseQuality-getMetric}{}}}
\subsection{Method \code{getMetric()}}{
Fetches metrics which match specified accession or name from the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCbaseQuality$getMetric(accession = NULL, name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{accession}}{Search by accession}

\item{\code{name}}{Search by name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCbaseQuality-toJSON"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCbaseQuality-toJSON}{}}}
\subsection{Method \code{toJSON()}}{
Creates JSON file from this object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCbaseQuality$toJSON(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional parameters for jsonlite:::asJSON()}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCbaseQuality-fromData"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCbaseQuality-fromData}{}}}
\subsection{Method \code{fromData()}}{
Sets data for this object from plain named lists of R objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCbaseQuality$fromData(mdata, context = "MzQCbaseQuality")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mdata}}{A datastructure of R lists/arrays as obtained by 'jsonlite::fromJSON()'}

\item{\code{context}}{Optional string describing location in mzQC structure that is used for more informative warning texts.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCbaseQuality-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCbaseQuality-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCbaseQuality$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
