% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roads-package.R
\docType{package}
\name{roads-package}
\alias{roads}
\alias{roads-package}
\title{roads: Road Network Projection}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Iterative least cost path and minimum spanning tree methods for projecting forest road networks. The methods connect a set of target points to an existing road network using 'igraph' \url{https://igraph.org} to identify least cost routes. The cost of constructing a road segment between adjacent pixels is determined by a user supplied weight raster and a weight function; options include the average of adjacent weight raster values, and a function of the elevation differences between adjacent cells that penalizes steep grades. These road network projection methods are intended for integration into R workflows and modelling frameworks used for forecasting forest change, and can be applied over multiple time-steps without rebuilding a graph at each time-step.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/LandSciTech/roads}
  \item \url{https://landscitech.github.io/roads/}
  \item Report bugs at \url{https://github.com/LandSciTech/roads/issues}
}

}
\author{
\strong{Maintainer}: Josie Hughes \email{josie.hughes@ec.gc.ca}

Authors:
\itemize{
  \item Sarah Endicott \email{sarah.endicott@ec.gc.ca} (\href{https://orcid.org/0000-0001-9644-5343}{ORCID})
  \item Kyle Lochhead \email{Kyle.Lochhead@gov.bc.ca}
  \item Patrick Kirby
}

Other contributors:
\itemize{
  \item Her Majesty the Queen in Right of Canada as represented by the Minister of the Environment (Copyright holder for included functions buildSimList, getLandingsFromTarget, pathsToLines, plotRoads, projectRoads, rasterizeLine, rasterToLineSegments) [copyright holder]
  \item Province of British Columbia (Copyright holder for included functions getGraph, lcpList, mstList, shortestPaths, getClosestRoad, buildSnapRoads) [copyright holder]
}

}
\keyword{internal}
