% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variance.R
\name{var_fun_unif_lbm}
\alias{var_fun_unif_lbm}
\title{Compute the Conditional variance of the LBM Robustness term by term}
\usage{
var_fun_unif_lbm(con, pi, rho, nr, nc)
}
\arguments{
\item{con}{A matrix, the connectivity parameter}

\item{pi}{A vector of length \code{nrow(con)}, the proportion of row blocks}

\item{rho}{A vector of length \code{ncol(con)}, the proportion of
column blocks}

\item{nr}{An integer, the number of row (primary) species}

\item{nc}{An integer, the number of column (secondary) species}
}
\value{
A vector, the variance after m extinctions
}
\description{
Compute the Conditional variance of the LBM Robustness term by term
}
\examples{
con <- matrix(c(.5,.3,.3,.1), 2, 2)
pi  <- c(.25,.75)
rho <- c(1/3, 2/3)
nr <- 50
nc <- 30
var_fun_unif_lbm(con, pi, rho, nr, nc)
}
