% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monte_carlo.R
\name{generate_param}
\alias{generate_param}
\title{Parameters of 2SLS model (Monte Carlo)}
\usage{
generate_param(
  dx1,
  dx2,
  dz2,
  intercept = TRUE,
  beta = NULL,
  sigma = 1,
  mean_z = NULL,
  cov_z = NULL,
  Sigma2_half = NULL,
  Omega2 = NULL,
  Pi = NULL,
  seed = 42
)
}
\arguments{
\item{dx1}{An integer value specifying the number of exogenous regressors.
This should include the intercept if it is present in the model
(see argument \code{intercept}).}

\item{dx2}{An integer value specifying the number of endogenous regressors.}

\item{dz2}{An integer value specifying the number of outside /
excluded instruments.}

\item{intercept}{A logical value (\code{TRUE} / \code{FALSE}) indicating
whether the model should contain an intercept.}

\item{beta}{A numeric vector of length \code{dx1 + dx2} specifying the
parameters of the structural equation.}

\item{sigma}{A strictly positive numeric value specifying the standard
deviation of the error in the structural model.}

\item{mean_z}{A numeric vector of length \code{dx1 + dz2} specifying the mean
of the exogenous variables, x1 and z2.}

\item{cov_z}{A numeric positive definite matrix specifying the
variance-covariance matrix of the exogenous variables, x1 and z2.}

\item{Sigma2_half}{A numeric positive definite matrix of dimension
\code{dx2} by \code{dx2} such that its square is the variance-covariance
matrix of the random first stage errors (Sigma2).}

\item{Omega2}{A numeric vector of length \code{dx1} specifying the
correlation between the scaled random first stage error and the structural
error.}

\item{Pi}{A numeric matrix of dimension \code{(dx1 + dz2)} by
\code{(dx1 + dx2)} specifying the first stage parameter matrix.}

\item{seed}{An integer for setting the seed for the random number generator.}
}
\value{
\code{generate_param} returns a list with the (randomly created or
user-specified) parameters that are required for drawing random data that.
The parameters are generated to fulfill the 2SLS model assumptions.

\describe{
  \item{\code{$structural}}{A list with two components storing the mean
  (\code{$mean}) and variance-covariance matrix (\code{$cov}) for the
  structural error (u), the random first stage errors (r2), and all
  instruments (excluding the intercept since it is not random) (z).}
  \item{\code{$params}}{A list storing the parameters of the 2SLS model.
  \code{$beta} is the coefficient vector (including intercept if present) of
  the structural equation, \code{$Pi} the coefficient matrix of the first
  stage projections, \code{$Omega2} the covariance between the structural
  error and the endogenous first stage errors, \code{$Sigma2_half} the square
  root of the variance-covariance matrix of the endogenous first stage
  errors, \code{$mean_z} the mean of all instruments (excluding the intercept
  since it is not random), \code{$cov_z} the variance-covariance matrix of
  the endogenous first-stage errors, \code{$Ezz} the expected value of the
  squared instruments.}
  \item{\code{$settings}}{A list storing the function call (\code{$call}),
  whether an intercept is included in the model (\code{$intercept}), a
  regression formula for the model setup (\code{$formula}), and the
  dimensions of the regressors and instruments (\code{$dx1}, \code{$dx2},
  \code{$dz2}.}
  \item{\code{$names}}{A list storing generic names for the regressors,
  instruments, and errors as character vectors (\code{$x1}, \code{$x2},
  \code{$x}, \code{$z2}, \code{$z}, \code{$r}, and \code{$u}).}
}
}
\description{
By default, \code{generate_param} creates random parameters of a 2SLS model
that satisfy conditions for 2SLS models, such as positive definite
variance-covariance matrices. The user can also specify certain parameters
directly, which are then checked for their validity.
}
