% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robGarch.R
\name{robGarch}
\alias{robGarch}
\title{Robust GARCH(1,1) Model Estimation}
\usage{
robGarch(
  data,
  fitMethod = c("BM", "M", "QML", "MLE"),
  robTunePars = c(0.8, 3),
  optChoice = c("Rsolnp", "nloptr", "nlminb"),
  initialPars = c(5e-04, 0.15, 0.75),
  SEmethod = c("numDeriv", "optim", "sandwich"),
  optControl = list(trace = 0)
)
}
\arguments{
\item{data}{an xts object}

\item{fitMethod}{character valued name of fitting method,
one of "BM", "M" "QML" or "tMLE", with "BM" the default value.}

\item{robTunePars}{a numeric vector c(cM,cFlt) that controls
the extent of fitMethod robustness, with default c(0.8,3.0).}

\item{optChoice}{character valued optChoice name, one of
"Rsolnp", "nloptr", "nlminb", with default "Rsolnp".}

\item{initialPars}{numeric user-defined initial parameters
c(gamma0, alpha0, beta0) for use by optChoice, with default
values c(0.0005, 0.15, 0.75).}

\item{SEmethod}{character valued name of standard error method,
one of "numDeriv", "optim", "sandwich", with default "numDeriv".}

\item{optControl}{list of arguments passed to optChoice, with
default \code{list(trace=0)}.}
}
\value{
A list object of class \dQuote{robustGarch} with components:
\item{data}{the input xts object}
\item{fitMethod}{the the fitMethod specified}
\item{robtunePars}{the robtunePars specified}
\item{initialPars}{the initialPars specified}
\item{optChoice}{the optChoice specified}
\item{coefEstimates}{computed parameter estimates}
\item{sigma}{conditional standard deviation xts class time series}
\item{SEmethod}{the specidied of calculating standard errors}
\item{observedInfoMat}{observed information matrix}
\item{optDetails}{a list containing the optChoice specified,
the control values specified, and the optChoice minimized
objective, and convergence status message}
}
\description{
Computes "BM" robust Garch(1,1) model parameter
estimate by using a bounded objective function and a bounded
conditional variance recursion.  Alternatively, it computes:
(1) "M" estimates by using only the bounded objective function,
(2) "QML" estimates based on a typically incorrect assumption
of normally distributed innovations, (3) "t-MLE" estimates based
on an assumption of an innovations t-distributed MLE with unknown
location, scale,and degrees of freedom parameters.
CHECK IF (3) IS CORRECT.
}
\details{
The "BM" fit method delivers the highest robustness by
using a half-Huber psi function to bound the normal distribution
log-likelihood, and using a Huber psi function to prevent the
propagation of influential outliers in the variance recursion.
The "M" method is obtained by dropping the BM bounding of the
variance recursion, and is therefore less robust toward outliers.

ECHO OR DAN, PLEASE PROVIDE DETAILS FOR optControl.
For details of the list of control arguments, please refer to
\code{nloptr::nloptr}, \code{Rsolnp::solnp}, \code{nlminb}.
The SEmethod default "numDeriv" is based on the Hessian from the
optimization.
}
\examples{
if (requireNamespace("PCRA", quietly = TRUE)) {
  ret <- PCRA::retOFG
  ret <- ret$RET
  (robFitBM <- robGarch(ret, fitMethod = "BM"))
  sum(robFitBM$fitted_pars[2:3])
  summary(robFitBM)
}

}
\references{
Muler, N. and Yohai, V. (2008). Robust estimates
for GARCH models. Journal of Statistical Planning and Inference,
138, 2918-2940.
}
