% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_evaluation.R
\name{extract_model_results}
\alias{extract_model_results}
\title{Extract and tidy model results from a column of models}
\usage{
extract_model_results(
  models,
  model_col = "model",
  tidy_fun = broom.mixed::tidy,
  .term = NULL
)
}
\arguments{
\item{models}{A data frame containing a column of fitted model objects.}

\item{model_col}{Unquoted column name containing the models. Default is \code{model}.}

\item{tidy_fun}{A tidying function to apply to each model. Default is \code{broom.mixed::tidy}.
The function must return a data frame with a \code{term} column.}

\item{.term}{Optional string specifying a term to filter after tidying (e.g., \code{"(Intercept)"}).
If \code{NULL} (default), all terms are retained.}
}
\value{
A tidy data frame with the original columns of \code{models} joined to the
tidied model results, typically including columns such as \code{term}, \code{estimate},
\code{std.error}, \code{statistic}, and \code{p.value}.
}
\description{
Applies a tidying function (default \code{broom.mixed::tidy}) to a column of models,
returning a tidy data frame with one row per term per model, suitable for downstream
summarisation and evaluation in simulation studies.
}
\examples{
library(dplyr)
library(purrr)
library(broom.mixed)

# Simulate and fit models
sim_models <- tibble(
  id = 1:5,
  model = map(1:5, ~ lm(mpg ~ wt, data = mtcars))
)

# Extract all terms
extract_model_results(sim_models)

# Extract only the slope term
extract_model_results(sim_models, .term = "wt")

}
