% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_generation.R
\name{initialize_replicates}
\alias{initialize_replicates}
\title{Add replicate identifiers for simulation replicates}
\usage{
initialize_replicates(long_schedule, n)
}
\arguments{
\item{long_schedule}{A long-format rollout schedule.}

\item{n}{Integer specifying the number of replicates to generate.}
}
\value{
A \code{tibble} with an added \code{sample_id} column for replicate indexing.
}
\description{
Expands a long-format schedule to include a replicate identifier for running multiple simulation replicates efficiently.
}
\examples{
schedule <- tibble::tibble(site = "A", cohort = 1, chron_time = 0, condition = "control")
initialize_replicates(schedule, n = 3)
}
