% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/planes.R
\name{plane_cover}
\alias{plane_cover}
\title{Coverage component}
\usage{
plane_cover(location, input, seed)
}
\arguments{
\item{location}{Character vector with location code; the location must appear in input and seed}

\item{input}{Input signal data to be scored; object must be one of \link[=to_signal]{forecast}}

\item{seed}{Prepared \link[=plane_seed]{seed}}
}
\value{
A \code{list} with the following values:
\itemize{
\item \strong{indicator}: Logical as to whether or not the last value falls outside of the interval (e.g., not in between lower and upper bounds of prediction interval) of the evaluated signal
\item \strong{last_value}: A vector with the last value recorded in the seed
\item \strong{bounds}: A list with a two elements corresponding to the upper and lower bounds of the evaluated signal interval
}
}
\description{
This function evaluates whether or not the evaluated signal interval covers the last observed value. The interval used in this plausibility component is drawn from the upper and lower bounds of the forecasted prediction interval. As such, the only accepted signal format is \link[=to_signal]{forecast}, which will include upper and lower bounds.
}
\examples{

## read in example observed data and prep observed signal
hosp <- read.csv(system.file("extdata/observed/hdgov_hosp_weekly.csv", package = "rplanes"))
hosp$date <- as.Date(hosp$date, format = "\%Y-\%m-\%d")
prepped_observed <- to_signal(hosp, outcome = "flu.admits", type = "observed", resolution = "weeks")

## read in example forecast and prep forecast signal
fp <- system.file("extdata/forecast/2022-10-31-SigSci-TSENS.csv", package = "rplanes")
prepped_forecast <- read_forecast(fp) \%>\%
  to_signal(., outcome = "flu.admits", type = "forecast", horizon = 4)

## prepare seed with cut date
prepped_seed <- plane_seed(prepped_observed, cut_date = "2022-10-29")

## run plane component
plane_cover(location = "08", input = prepped_forecast, seed = prepped_seed)
plane_cover(location = "47", input = prepped_forecast, seed = prepped_seed)
}
