% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seed.R
\name{plane_seed}
\alias{plane_seed}
\title{Create seed}
\usage{
plane_seed(input, cut_date = NULL)
}
\arguments{
\item{input}{Input signal data used for seeding; must be an observed signal object}

\item{cut_date}{Maximum date (inclusive) for which seeding should be performed; default is \code{NULL} and the entire input will be used for seeding}
}
\value{
A named \code{list} of length \emph{n}, where multiple elements corresponding to seed characteristics and metadata for each of the \emph{n} locations are nested in independent lists.
}
\description{
This function wraps the \link{seed_engine} to operate across all locations in the input signal.
}
\examples{
## read in example observed data and prep observed signal
hosp <- read.csv(system.file("extdata/observed/hdgov_hosp_weekly.csv", package = "rplanes"))
hosp$date <- as.Date(hosp$date, format = "\%Y-\%m-\%d")
prepped_observed <- to_signal(hosp, outcome = "flu.admits", type = "observed", resolution = "weeks")

## prepare seed with no cut date
plane_seed(prepped_observed)

## prepare seed with cut date
plane_seed(prepped_observed, cut_date = "2022-10-29")

}
