% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/null_replace.R
\name{null_replace}
\alias{null_replace}
\title{Create a null_replace node.}
\usage{
null_replace(src, cols, value, ..., note_col = NULL, env = parent.frame())
}
\arguments{
\item{src}{relop or data.frame data source.}

\item{cols}{character, columns to work on.}

\item{value}{scalar, value to write.}

\item{...}{force later arguments to bind by name.}

\item{note_col}{character, if not NULL record number of columns altered per-row in this column.}

\item{env}{environment to look to.}
}
\value{
null_replace node or data.frame.
}
\description{
Replace NA/NULL is specified columns with the given replacement value.
}
\examples{

if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d1 <- rq_copy_to(my_db, 'd1',
                    data.frame(A = c(NA, 2, 3, NA), B = c(3, NA, 4, NA)))
  optree <- null_replace(d1, qc(A, B),
                         0.0, note_col = "alterations")
  cat(format(optree))
  sql <- to_sql(optree, my_db)
  cat(sql)
  print(DBI::dbGetQuery(my_db, sql))
  DBI::dbDisconnect(my_db)
}

}
\seealso{
\code{\link{count_null_cols}}, \code{\link{mark_null_cols}}
}
