% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{rdasim2}
\alias{rdasim2}
\title{Generate simulated data for Ridge Redundancy Analysis (RDA).}
\usage{
rdasim2(n, p, q, k, s2n = 5, xofd = 0)
}
\arguments{
\item{n}{The number of samples.}

\item{p}{The number of variables of X.}

\item{q}{The number of variables of Y.}

\item{k}{The number of latent variables.}

\item{s2n}{The numeric parameter of signal to noise ratio, default value is 5.}

\item{xofd}{The numeric parameter of the off-diagnal elements of covariance matrix of X, default is 0.}
}
\value{
A list containing matrices X, Y, B, E.
}
\description{
The rdasim2 function generates simulated data for Ridge Redundancy Analysis (RDA) with adjustable signal-to-noise ratio and covariance structure for X. The data matrix Y is created by a low-rank model, where the rank is set by the product of two matrices A and C corresponding to the number of latent variables (k). The function allows control over the signal-to-noise ratio (s2n) and off-diagonal elements of the covariance matrix for X (xofd). It returns a list containing the matrices X, Y, the regression coefficient matrix B (obtained as the product of A and C), and the error matrix E.
}
\examples{
# Example usage of rdasim2
set.seed(10)
sim_data2 <- rdasim2(n = 10, p = 5, q = 3, k = 2)
str(sim_data2)
}
