% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regcom.R
\name{regcom}
\alias{regcom}
\title{Barplot with point and table for comparison}
\usage{
regcom(data, x, yl, yc, tab = TRUE, title, scale, ascending = TRUE, col1,
  col2, lab1, lab2, num, rotate, leg1, leg2, ...)
}
\arguments{
\item{data}{Data set}

\item{x}{x-axis}

\item{yl}{Variable or column for local values}

\item{yc}{Variable or column for national values}

\item{tab}{Include table}

\item{title}{Title for the plot}

\item{scale}{Scale for x-axis ie. percentage or number}

\item{ascending}{Sort data ascending order}

\item{col1}{Color for bars}

\item{col2}{Color for the 'diff' bar}

\item{lab1}{Label for table first column}

\item{lab2}{Label for table second column}

\item{num}{Include denominator i.e N in the figure eg. Tawau HF (N=2088)}

\item{rotate}{Rotate table text}

\item{leg1}{Text legend for bar}

\item{leg2}{Text legend for point}

\item{...}{Additional arguments}
}
\description{
Create a barplot with point to visualise comparison. It is also possible to
include table to show the value of the plot.
}
\examples{
library("rreg")
regcom(data = hfdata, x = inst, yl = case2, yc = case1)

# include table
regcom(data = hfdata, x = inst, yl = case2, yc = case1, tab = FALSE)

# keep original order
regcom(data = hfdata, x = inst, yl = case2, yc = case1, scale = "Percentage", ascending = FALSE)

# text for table rotate 10\%
regcom(data = hfdata, x = inst, yl = case2, yc = case1, lab1="Tawau", lab2="Negara", rotate=10)

}
