% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deployAPI.R
\name{deployAPI}
\alias{deployAPI}
\title{Deploy a Plumber API}
\usage{
deployAPI(api, ...)
}
\arguments{
\item{api}{Path to the API project directory. Must contain either
\code{entrypoint.R} or \code{plumber.R} (for plumber APIs) or \verb{_server.yml} (for
plumber2 APIs)}

\item{...}{Additional arguments to \code{\link[=deployApp]{deployApp()}}.}
}
\description{
Deploys an application consisting of plumber API routes. The given directory
must contain a script returning a \code{plumb} object or a plumber API definition.

Supported servers: Posit Connect and ShinyApps servers
}
\details{
Deploy a plumber API definition by either supplying a directory
containing \code{plumber.R} (an API definition) or \code{entrypoint.R} that returns a
\code{plumb} object created by \code{plumber::plumb()}. See the plumber documentation
for more information. Alternatively, deploy a plumber2 API by supplying a
directory containing \verb{_server.yml}.
}
\seealso{
Other Deployment functions: 
\code{\link{applications}()},
\code{\link{deployApp}()},
\code{\link{deployDoc}()},
\code{\link{deploySite}()},
\code{\link{deployTFModel}()}
}
\concept{Deployment functions}
