% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imgcat.R
\name{imgcat}
\alias{imgcat}
\title{Create SIXEL escape sequence for image file}
\usage{
imgcat(
  path,
  ...,
  max.colors = 256,
  iter.max = 10,
  background = "white",
  file = ""
)
}
\arguments{
\item{path}{character, path to a image file.}

\item{...}{other positional arguments will be omitted.}

\item{max.colors}{integer, max colors of the palette. The maximum is 256.
This parameter will be passed to \code{\link{sixelEncode}}.}

\item{iter.max}{integer, maximum number of iterations for k-means clustering.
This parameter will be passed to \code{\link{sixelEncode}}.}

\item{background}{character, background color to blend with for pixel with
transparency. Default is "white".}

\item{file}{A connection, or a character string naming the file to print to.
This parameter will be passed to \code{cat}}
}
\value{
None (invisible 'NULL').
}
\description{
Create SIXEL escape sequence for image file. \code{jpeg}, \code{png} or \code{magick} packages
are required to read image files. Image with alpha channel will be blended with
the specified background color.
}
\examples{
imgcat(system.file("img", "Rlogo.jpg", package="jpeg"))
}
